#!/bin/sh
# ---------------------------------------------------
# Start Script for the GeoRasterETL
#
# Environment Variable Prequisites
#
#   ORACLE_HOME     Oracle database installation home.
# ---------------------------------------------------

# Get required environment variables
if [ ! -r "$ORACLE_HOME"/jdk/bin/java ]; then
  echo "Cannot find $ORACLE_HOME/jdk/bin/java"
  echo "This file is needed to run this program"
  exit 1
fi


# Oracle JDBC and XML parser JARs:
JARS=$ORACLE_HOME/jdbc/lib/ojdbc6.jar
JARS="$JARS":$ORACLE_HOME/lib/xmlparserv2.jar
JARS="$JARS":$ORACLE_HOME/lib/xschema.jar
JARS="$JARS":$ORACLE_HOME/lib/xml.jar
JARS="$JARS":$ORACLE_HOME/jlib/jewt4.jar
JARS="$JARS":$ORACLE_HOME/jlib/share.jar

# GeoRaster JAR:
JARS="$JARS":$ORACLE_HOME/md/demo/georaster/etl/georaster_etl.jar

# Third Party jars:
JARS="$JARS":$ORACLE_HOME/md/demo/georaster/etl/gdal/lib/gdal.jar

# Third Party libraries:
LD_LIBRARY_PATH=$ORACLE_HOME/md/demo/georaster/etl/gdal/lib:"$LD_LIBRARY_PATH"
GDAL_DRIVER_PATH=$ORACLE_HOME/md/demo/georaster/etl/gdal/lib/gdalplugins

# Third Party data:
GDAL_DATA=$ORACLE_HOME/md/demo/georaster/etl/gdal/data

# GeoRasterETL JAR:
GEORASTERETL_CLASS=oracle.spatial.georaster.tools.etl.GeoRasterETL

#Note: JDK1.6 and up is required to run this program.
exec $ORACLE_HOME/jdk/bin/java -classpath "$JARS" $GEORASTERETL_CLASS
